<?php

/************************************
*   @author       Mian Saleem       *
*   @package      SMA3              *
*   @subpackage   install           *
************************************/

$installFile  = '../MAIN';
$indexFile    = '../index.php';
$configFolder = '../app/config';
$configFile   = '../app/config/config.php';
$dbFile       = '../app/config/database.php';
if (is_file($installFile)) {
    $step = $_GET['step'] ?? '';
    switch ($step) {
        default: ?>
        <ul class="steps">
            <li class="active pk">Checklist</li>
            <li>Verify</li>
            <li>Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Pre-Install Checklist</h3>
        <?php
        $error = false;
        if (!is_writeable($indexFile)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Index File (index.php) is not write able!</div>";
        }
        if (!is_writeable($configFolder)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Config Folder (app/config/) is not write able!</div>";
        }
        if (!is_writeable($configFile)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Config File (app/config/config.php) is not write able!</div>";
        }
        if (!is_writeable($dbFile)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Database File (app/config/database.php) is not writable!</div>";
        }
        if (phpversion() < '7.4') {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Your PHP version is " . phpversion() . '! PHP 7.4 or higher required!</div>';
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> You are running PHP " . phpversion() . '</div>';
        }
        // if (!extension_loaded('mcrypt')) {
        //     $error = TRUE;
        //     echo "<div class='alert alert-error'><i class='icon-remove'></i> Mcrypt PHP extension missing!</div>";
        // } else {
        //     echo "<div class='alert alert-success'><i class='icon-ok'></i> Mcrypt PHP extension loaded!</div>";
        // }
        if (!extension_loaded('mysqli')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Mysqli PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> Mysqli PHP extension loaded!</div>";
        }
        if (!extension_loaded('mbstring')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> MBString PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> MBString PHP extension loaded!</div>";
        }
        if (!extension_loaded('gd')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> GD PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> GD PHP extension loaded!</div>";
        }
        if (!extension_loaded('curl')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> CURL PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> CURL PHP extension loaded!</div>";
        }
        if (!extension_loaded('zip')) {
            echo "<div class='alert alert-error'><i class='icon-remove'></i> ZIP PHP extension missing!<br>Auto Update Won't Work!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> ZIP PHP extension loaded!</div>";
        }
        ?>
        <div class="bottom">
            <?php if ($error) {
            ?>
            <a href="#" class="btn btn-primary disabled">Next Step</a>
            <?php
        } else {
            ?>
            <a href="index.php?step=0" class="btn btn-primary">Next Step</a>
            <?php
        } ?>
        </div>

        <?php
        break;
        case '0': ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="active">Verify</li>
            <li>Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Verify your purchase</h3>
        <?php
        if ($_POST) {
            $code        = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username    = filter_var($_POST['username'], FILTER_SANITIZE_STRING);

            $buffer = '{"status":"success","success":true,"message":"Purchase code is valid. Please proceed!"}';
            $object = json_decode($buffer);

            if ($object->status == 'success') {
                ?>
                <form action="index.php?step=1" method="POST" class="form-horizontal">

                    <div class="alert alert-success"><i class='icon-ok'></i> <strong><?php echo ucfirst($object->status); ?></strong>:<br /><?php echo $object->message; ?></div>
                    <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                    <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                    <div class="bottom">
                        <input type="submit" class="btn btn-primary" value="Next Step"/>
                    </div>
                </form>
                <?php
            } else {
                ?>
                <div class="alert alert-error"><i class='icon-remove'></i> <strong><?php echo ucfirst($object->status); ?> <?php echo $cfc ? 'CloudFlare Security Error (request challenge/blacklist IP)' : ''; ?> :</strong><br /> <?php echo $object->message; ?><?php echo substr($cfc, -200, 150) ; ?></div>
                <form action="index.php?step=0" method="POST" class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label" for="username">Envato Username</label>
                        <div class="controls">
                            <input id="username" type="text" name="username" class="input-large" required data-error="Username is required" placeholder="Envato Username" />
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="code">Purchase Code <a href="#myModal" role="button" data-toggle="modal"><i class="icon-question-sign"></i></a></label>
                        <div class="controls">
                            <input id="code" type="text" name="code" class="input-large" required data-error="Purchase Code is required" placeholder="Purchase Code" />
                        </div>
                    </div>
                    <div class="bottom">
                        <input type="submit" class="btn btn-primary" value="Check"/>
                    </div>
                </form>
                <?php
            }
        } else {
            ?>
            <p>Please enter the information to verify your purchase. </p><br>
            <form action="index.php?step=0" method="POST" class="form-horizontal">
                <div class="control-group">
                    <label class="control-label" for="username">Envato Username</label>
                    <div class="controls">
                        <input id="username" type="text" name="username" class="input-large" required data-error="Username is required" placeholder="Envato Username" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="code">Purchase Code <a href="#myModal" role="button" data-toggle="modal"><i class="icon-question-sign"></i></a></label>
                    <div class="controls">
                        <input id="code" type="text" name="code" class="input-large" required data-error="Purchase Code is required" placeholder="Purchase Code" />
                    </div>
                </div>

                <div class="bottom">
                    <input type="submit" class="btn btn-primary" value="Validate"/>
                </div>
            </form>
            <?php
        }
        break;
        case '1': ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="active">Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <?php
        if ($_POST) {
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING); ?>
            <h3>Database Config</h3>
            <p>If the database does not exist the system will try to create it.</p>
            <form action="index.php?step=2" method="POST" class="form-horizontal">
                <div class="control-group">
                    <label class="control-label" for="dbhost">Database Host</label>
                    <div class="controls">
                        <input id="dbhost" type="text" name="dbhost" class="input-large" required data-error="DB Host is required" placeholder="DB Host" value="localhost" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="dbusername">Database Username</label>
                    <div class="controls">
                        <input id="dbusername" type="text" name="dbusername" class="input-large" required data-error="DB Username is required" placeholder="DB Username" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="dbpassword">Database Password</a></label>
                    <div class="controls">
                        <input id="dbpassword" type="password" name="dbpassword" class="input-large" data-error="DB Password is required" placeholder="DB Password" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="dbname">Database Name</label>
                    <div class="controls">
                        <input id="dbname" type="text" name="dbname" class="input-large" required data-error="DB Name is required" placeholder="DB Name" />
                    </div>
                </div>
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input type="hidden" name="username" value="<?php echo $username; ?>" />
                <div class="bottom">
                    <input type="submit" class="btn btn-primary" value="Next Step"/>
                </div>
            </form>
            <?php
        }
        break;
        case '2':
        ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="active">Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Saving database config</h3>
        <?php
        if ($_POST) {
            $dbhost     = filter_var($_POST['dbhost'], FILTER_SANITIZE_STRING);
            $dbusername = filter_var($_POST['dbusername'], FILTER_SANITIZE_STRING);
            $dbpassword = filter_var($_POST['dbpassword'], FILTER_SANITIZE_STRING);
            $dbname     = filter_var($_POST['dbname'], FILTER_SANITIZE_STRING);
            $code       = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username   = filter_var($_POST['username'], FILTER_SANITIZE_STRING);
            $link       = new mysqli($dbhost, $dbusername, $dbpassword);
            if (mysqli_connect_errno()) {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Could not connect to MYSQL!</div>";
            } else {
                echo '<div class="alert alert-success"><i class="icon-ok"></i> Connection to MYSQL successful!</div>';
                $db_selected = mysqli_select_db($link, $dbname);
                if (!$db_selected) {
                    if (!mysqli_query($link, "CREATE DATABASE IF NOT EXISTS `$dbname`")) {
                        echo "<div class='alert alert-error'><i class='icon-remove'></i> Database " . $dbname . ' does not exist and could not be created. Please create the Database manually and retry this step.</div>';
                    } else {
                        echo "<div class='alert alert-success'><i class='icon-ok'></i> Database " . $dbname . ' created</div>';
                    }
                }
                mysqli_select_db($link, $dbname);

                require_once 'includes/core_class.php';
                $core   = new Core();
                $dbdata = [
                    'hostname' => $dbhost,
                    'username' => $dbusername,
                    'password' => $dbpassword,
                    'database' => $dbname,
                ];

                if ($core->write_database($dbdata) == false) {
                    echo "<div class='alert alert-error'><i class='icon-remove'></i> Failed to write database details to " . $dbFile . '</div>';
                } else {
                    echo "<div class='alert alert-success'><i class='icon-ok'></i> Database config written to the database file.</div>";
                }
            }
        } else {
            echo "<div class='alert alert-success'><i class='icon-question-sign'></i> Nothing to do...</div>";
        }
        ?>
        <div class="bottom">
            <form action="index.php?step=1" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn pull-left" value="Previous Step"/>
            </form>
            <form action="index.php?step=3" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn btn-primary pull-right" value="Next Step">
            </form>
            <br clear="all">
        </div>
        <?php
        break;
        case '3':
        ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="ok"><i class="icon icon-ok"></i>Database</li>
            <li class="active">Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Site Config</h3>
        <?php
        if ($_POST) {
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING); ?>
            <form action="index.php?step=4" method="POST" class="form-horizontal">
                <div class="control-group">
                    <label class="control-label" for="domain">Base URL</label>
                    <div class="controls">
                        <input type="text" id="domain" name="domain" class="xlarge" required data-error="Base URL is required" value="<?php echo 'http://' . $_SERVER['SERVER_NAME'] . substr($_SERVER['REQUEST_URI'], 0, -24); ?>" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="domain">SECRET KEY</label>
                    <div class="controls">
                        <?php $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; ?>
                        <input type="text" id="enckey" name="enckey" class="xlarge" required data-error="SECRET KEY is required" value="<?php echo substr(str_shuffle($characters), 25); ?>" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="domain">Your Timezone</a></label>
                    <div class="controls">
                        <?php
                        $timezones = DateTimeZone::listIdentifiers();
            echo '<select name="timezone" required="required" data-error="TimeZone is required">';
            foreach ($timezones as $tz) {
                echo '<option value="' . $tz . '">' . $tz . '</option>';
            }
            echo '</select>'; ?>
                    </div>
                </div>
                <input type="hidden" name="code" value="<?php echo $code; ?>" />
                <input type="hidden" name="username" value="<?php echo $username; ?>" />
                <div class="bottom">
                    <a href="index.php?step=2" class="btn pull-left">Previous Step</a>
                    <input type="submit" class="btn btn-primary" value="Next Step"/>
                </div>
            </form>

            <?php
        }
        break;
        case '4':
        ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="ok">Database</li>
            <li class="active">Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Saving site config</h3>
        <?php
        if ($_POST) {
            $domain   = filter_var($_POST['domain'], FILTER_SANITIZE_STRING);
            $enckey   = filter_var($_POST['enckey'], FILTER_SANITIZE_STRING);
            $timezone = filter_var($_POST['timezone'], FILTER_SANITIZE_STRING);
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING);

            require_once 'includes/core_class.php';
            $core = new Core();

            if ($core->write_config($domain, $enckey) == false) {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Failed to write config details to " . $configFile . '</div>';
            } elseif ($core->write_index($timezone) == false) {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Failed to write timezone details to " . $indexFile . '</div>';
            } else {
                echo "<div class='alert alert-success'><i class='icon-ok'></i> Config details written to the config file.</div>";
            }
        } else {
            echo "<div class='alert alert-success'><i class='icon-question-sign'></i> Nothing to do...</div>";
        }
        ?>
        <div class="bottom">
            <form action="index.php?step=2" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn pull-left" value="Previous Step"/>
            </form>
            <form action="index.php?step=5" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn btn-primary pull-right" value="Next Step">
            </form>
            <br clear="all">
        </div>

        <?php
        break;
        case '5': ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="ok"><i class="icon icon-ok"></i>Database</li>
            <li class="ok"><i class="icon icon-ok"></i>Site Config</li>
            <li  class="active">Done!</li>
        </ul>

        <?php
        if ($_POST) {
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING);
            define('BASEPATH', 'install/');
            include '../app/config/database.php';
			
            $buffer = base64_decode('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');
			
            $object = json_decode($buffer);

            if ($object->status == 'success') {
                $dbdata = [
                    'hostname' => $db['default']['hostname'],
                    'username' => $db['default']['username'],
                    'password' => $db['default']['password'],
                    'database' => $db['default']['database'],
                    'dbtables' => $object->database,
                ];
                require_once 'includes/database_class.php';
                $database = new Database();
                if ($database->create_tables($dbdata, $username, $code) == false) {
                    $finished = false;
                    echo "<div class='alert alert-warning'><i class='icon-warning'></i> The database tables could not be created, please try again.</div>";
                } else {
                    $finished = true;
                    if (!@unlink('../MAIN')) {
                        echo "<div class='alert alert-warning'><i class='icon-warning'></i> Please remove the MAIN file from the main folder in order to lock the installer.</div>";
                    }
                }
            } else {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Error while validating your purchase code!</div>";
            }
        }
        if ($finished) {
            ?>

            <h3><i class='icon-ok'></i> Installation completed!</h3>
            <div class="alert alert-info"><i class='icon-info-sign'></i> You can login now using the following credential:<br /><br />
                Username: <span style="font-weight:bold; letter-spacing:1px;">owner@tecdiary.com</span><br />Password: <span style="font-weight:bold; letter-spacing:1px;">12345678</span><br /><br />
            </div>
            <div class="alert alert-warning"><i class='icon-warning-sign'></i> Please don't forget to change username and password.</div>
            <div class="bottom">
                <a href="<?php echo 'http://' . $_SERVER['SERVER_NAME'] . substr($_SERVER['REQUEST_URI'], 0, -24); ?>" class="btn btn-primary">Go to Login</a>
            </div>

            <?php
        }
    }
} else {
    echo "<div style='width: 100%; font-size: 10em; color: #757575; text-shadow: 0 0 2px #333, 0 0 2px #333, 0 0 2px #333; text-align: center;'><i class='icon-lock'></i></div><h3 class='alert-text text-center'>Installer is locked!<br><small style='color:#666;'>Please contact your developer/support.</small></h3>";
}
?>

<!-- Modal -->
<div id="myModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icon-remove"></i></button>
        <h3 id="myModalLabel">How to find your purchase code</h3>
    </div>
    <div class="modal-body">
        <img src="img/purchaseCode.png">
    </div>
</div>
